/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api.security;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.security.stores.WssKeyStoreConfiguration;
import org.mule.soap.internal.security.callback.WSPasswordCallbackHandler;

public class WssDecryptSecurityStrategy
implements SecurityStrategy {
    private static final String WS_DECRYPT_PROPERTIES_KEY = "decryptProperties";
    private WssKeyStoreConfiguration keyStoreConfiguration;

    public WssDecryptSecurityStrategy(WssKeyStoreConfiguration keyStoreConfiguration) {
        this.keyStoreConfiguration = keyStoreConfiguration;
    }

    @Override
    public SecurityStrategy.SecurityStrategyType securityType() {
        return SecurityStrategy.SecurityStrategyType.INCOMING;
    }

    @Override
    public String securityAction() {
        return "Encrypt";
    }

    @Override
    public Optional<WSPasswordCallbackHandler> buildPasswordCallbackHandler() {
        return Optional.of(new WSPasswordCallbackHandler(1, cb -> cb.setPassword(this.keyStoreConfiguration.getKeyPassword())));
    }

    @Override
    public Map<String, Object> buildSecurityProperties() {
        return ImmutableMap.builder().put((Object)"decryptionPropRefId", (Object)WS_DECRYPT_PROPERTIES_KEY).put((Object)WS_DECRYPT_PROPERTIES_KEY, (Object)this.keyStoreConfiguration.getConfigurationProperties()).build();
    }
}

