/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.ByteArrayInputStream;
import java.util.Collections;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.message.Exchange;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.message.DefaultSoapResponse;
import org.mule.soap.internal.message.EmptySoapResponse;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.w3c.dom.Document;

public final class SoapResponseGenerator {
    private final AttachmentResponseEnricher responseEnricher;

    public SoapResponseGenerator(AttachmentResponseEnricher responseEnricher) {
        this.responseEnricher = responseEnricher;
    }

    public SoapResponse generate(String operation, Object[] response, Exchange exchange) {
        Map<String, String> transportHeaders = this.getTransportHeaders(exchange);
        Map<String, String> transportAdditionalData = this.getTransportAdditionalData(exchange);
        if (response == null) {
            return new EmptySoapResponse(transportHeaders, transportAdditionalData);
        }
        Document document = this.unwrapResponse(response);
        String result = this.responseEnricher.enrich(document, operation, exchange);
        Map attachments = (Map)exchange.get((Object)"mule.soap.attachments");
        Map headers = (Map)exchange.get((Object)"mule.soap.headers");
        ByteArrayInputStream body = new ByteArrayInputStream(result.getBytes());
        return new DefaultSoapResponse(body, headers, transportHeaders, transportAdditionalData, attachments, "application/xml");
    }

    private Map<String, String> getTransportHeaders(Exchange exchange) {
        Map transportHeaders = (Map)exchange.get((Object)"mule.soap.transport.headers");
        return transportHeaders == null ? Collections.emptyMap() : transportHeaders;
    }

    private Map<String, String> getTransportAdditionalData(Exchange exchange) {
        Map transportAdditionalData = (Map)exchange.get((Object)"mule.soap.transport.additionalData");
        return transportAdditionalData == null ? Collections.emptyMap() : transportAdditionalData;
    }

    private Document unwrapResponse(Object[] response) {
        if (response.length == 0) {
            throw new BadResponseException("no elements were received in the SOAP response.");
        }
        if (response.length != 1) {
            throw new BadResponseException("the obtained response contains more than one element, only one was expected");
        }
        XMLStreamReader reader = (XMLStreamReader)response[0];
        try {
            return XmlTransformationUtils.xmlStreamReaderToDocument(reader);
        }
        catch (XmlTransformationException e) {
            throw new BadResponseException("Error transforming the XML web service response to be processed", e);
        }
    }
}

