/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.generator.attachment.SoapAttachmentResponseEnricher;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.w3c.dom.Document;

public class SoapAttachmentsResponseEnricherTestCase
extends AbstractEnricherTestCase {
    private AttachmentResponseEnricher enricher;

    @Override
    @Before
    public void setup() {
        super.setup();
        List ops = this.model.getService("TestService").getPort("TestPort").getOperations();
        this.enricher = new SoapAttachmentResponseEnricher(ops);
    }

    @Test
    public void enrichWindows1252EncodingAttachment() throws Exception {
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>QWxndW0gQ29udGX6ZG8gZW0gUG9ydHVndepzIHBhcmEgV2luZG93cw==</attachment></con:downloadAttachmentResponse>";
        ExchangeImpl exchange = new ExchangeImpl();
        Document doc = XmlTransformationUtils.stringToDocument((String)response);
        String result = this.enricher.enrich(doc, "downloadAttachment", (Exchange)exchange);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange, "Algum Conte\u00fado em Portugu\u00eas para Windows", "windows-1252");
    }

    @Test
    public void enrichUtf8EncodingAttachment() throws Exception {
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>U29tZSBDb250ZW50</attachment></con:downloadAttachmentResponse>";
        ExchangeImpl exchange = new ExchangeImpl();
        Document doc = XmlTransformationUtils.stringToDocument((String)response);
        String result = this.enricher.enrich(doc, "downloadAttachment", (Exchange)exchange);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange, "Some Content", "UTF-8");
    }

    private void assertAttachment(Exchange exchange, String attachmentText, String attachmentEncoding) throws Exception {
        Map attachments = (Map)exchange.get((Object)"mule.soap.attachments");
        MatcherAssert.assertThat(attachments.entrySet(), (Matcher)Matchers.hasSize((int)1));
        String value = IOUtils.toString((InputStream)((SoapAttachment)attachments.get("attachment")).getContent(), (String)attachmentEncoding);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)attachmentText));
    }
}

