/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor;

import com.google.common.collect.ImmutableMap;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.w3c.dom.Node;

public class OutputSoapHeadersInterceptor
extends AbstractSoapInterceptor {
    public OutputSoapHeadersInterceptor() {
        super("pre-protocol");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        ImmutableMap.Builder headers = ImmutableMap.builder();
        message.getHeaders().stream().filter(header -> header instanceof SoapHeader).map(h -> (SoapHeader)h).forEach(header -> headers.put((Object)header.getName().getLocalPart(), (Object)this.getHeaderInputStream((SoapHeader)header)));
        message.getExchange().put((Object)"mule.soap.headers", (Object)headers.build());
    }

    private String getHeaderInputStream(SoapHeader h) {
        try {
            return XmlTransformationUtils.nodeToString((Node)h.getObject());
        }
        catch (XmlTransformationException e) {
            throw new BadResponseException(String.format("Error while processing response header [%s]", h.getName()), e);
        }
    }
}

