/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.rm;

import java.util.Optional;

/**
 * Represents a request that aims to create a RM sequence
 *
 * @since 1.6
 */
public interface CreateSequenceRequest {

  /**
   * @return the sequence TTL expresed in milliseconds.
   */
  long getSequenceTtl();

  /**
   * @return the Reliable Messaging namespace uri
   */
  String getNamespaceUri();

  /**
   * @return the WS-Addressing namespace uri
   */
  Optional<String> getAddressingNamespaceUri();

  /**
   * @return a {@link CreateSequenceRequestBuilder} instance to create a new {@link CreateSequenceRequest}.
   */
  static CreateSequenceRequestBuilder builder() {
    return new CreateSequenceRequestBuilder();
  }
}
