/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.ws.rm.RMInInterceptor;
import org.apache.cxf.ws.rm.RMDeliveryInterceptor;
import org.apache.cxf.ws.rm.RMCaptureInInterceptor;
import org.apache.cxf.ws.rm.soap.RMSoapInInterceptor;

import static org.mule.soap.internal.rm.RMUtils.isReliableMessagingEnable;

public class SkipReliableMessagingInInterceptor extends AbstractSoapInterceptor {

  private final RMInInterceptor rmLogicalIn;
  private final RMDeliveryInterceptor rmDelivery;
  private final RMSoapInInterceptor rmInCodec;
  private final RMCaptureInInterceptor rmCaptureIn;

  public SkipReliableMessagingInInterceptor(RMInInterceptor rmLogicalIn, RMDeliveryInterceptor rmDelivery,
                                            RMSoapInInterceptor rmInCodec, RMCaptureInInterceptor rmCaptureIn) {
    super(SkipReliableMessagingInInterceptor.class.getName(), "receive");
    this.rmLogicalIn = rmLogicalIn;
    this.rmDelivery = rmDelivery;
    this.rmInCodec = rmInCodec;
    this.rmCaptureIn = rmCaptureIn;
  }

  @Override
  public void handleMessage(SoapMessage soapMessage) {
    if (!isReliableMessagingEnable(soapMessage)) {
      soapMessage.getInterceptorChain().remove(rmLogicalIn);
      soapMessage.getInterceptorChain().remove(rmInCodec);
      soapMessage.getInterceptorChain().remove(rmDelivery);
      soapMessage.getInterceptorChain().remove(rmCaptureIn);
    }
  }
}
