/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.rm;

import org.mule.soap.api.rm.TerminateSequenceRequest;

/**
 * Default implementation of a {@link TerminateSequenceRequest}
 *
 * @since 1.6
 */
public class DefaultTerminateSequenceRequest implements TerminateSequenceRequest {

  private final String sequenceIdentifier;

  public DefaultTerminateSequenceRequest(String sequenceIdentifier) {
    this.sequenceIdentifier = sequenceIdentifier;
  }

  @Override
  public String getSequenceIdentifier() {
    return sequenceIdentifier;
  }
}
