/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Assert;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.DefaultSoapRequest;

public class CustomDispatcherTestCase
extends AbstractSoapServiceTestCase {
    private static final String RESPONSE = "<text>RESPONSE</text>";

    @Test
    public void customDispatcher() throws Exception {
        SoapResponse response = this.getTestClient().consume(SoapRequest.empty((String)"noParams"), new TestDispatcher());
        SoapTestUtils.assertSimilarXml(RESPONSE, response.getContent());
    }

    @Test
    public void transportHeaders() {
        DefaultSoapRequest request = SoapRequest.builder().operation("noParams").transportHeaders((Map)ImmutableMap.builder().put((Object)"H1", (Object)"H1Value").put((Object)"H2", (Object)"H2Value").build()).build();
        SoapResponse response = this.getTestClient().consume((SoapRequest)request, new TestDispatcher());
        Map transportHeaders = response.getTransportHeaders();
        Assert.assertThat(transportHeaders.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        Assert.assertThat(transportHeaders.get("h1"), (Matcher)Matchers.is((Object)"H1Value"));
        Assert.assertThat(transportHeaders.get("H1"), (Matcher)Matchers.is((Object)"H1Value"));
        Assert.assertThat(transportHeaders.get("h2"), (Matcher)Matchers.is((Object)"H2Value"));
        Assert.assertThat(transportHeaders.get("H2"), (Matcher)Matchers.is((Object)"H2Value"));
        Assert.assertTrue((boolean)transportHeaders.containsKey("Content-Type"));
        Assert.assertTrue((boolean)transportHeaders.containsKey("content-type"));
        Assert.assertTrue((boolean)transportHeaders.containsKey("Content-type"));
        Assert.assertTrue((boolean)transportHeaders.containsKey("CONTENT-TYPE"));
    }

    private TestSoapClient getTestClient() {
        return new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withVersion(this.soapVersion).build());
    }

    public class TestDispatcher
    implements TransportDispatcher {
        public TransportResponse dispatch(TransportRequest dispatchingRequest) {
            String envelope = "<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\"><s:Body><text>RESPONSE</text></s:Body></s:Envelope>";
            return new TransportResponse((InputStream)new ByteArrayInputStream(envelope.getBytes()), dispatchingRequest.getHeaders(), Collections.emptyMap());
        }
    }
}

