/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.client;

import javax.activation.DataSource;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamDataSource implements DataSource {

  private final InputStream data;
  private final String contentType;
  private final String name;

  public StreamDataSource(InputStream data, String contentType, String name) {
    this.data = data;
    this.contentType = contentType;
    this.name = name;
  }

  @Override
  public InputStream getInputStream() {
    return data;
  }

  @Override
  public String getContentType() {
    return this.contentType;
  }

  @Override
  public OutputStream getOutputStream() {
    throw new UnsupportedOperationException("Cannot write into an InputStreamDataSource");
  }

  @Override
  public String getName() {
    return name;
  }

}
