/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.rm.store;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.message.ReliableMessagingProperties;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.rm.CreateSequenceRequest;
import org.mule.soap.api.rm.ReliableMessagingConfiguration;
import org.mule.soap.api.rm.ReliableMessagingStore;
import org.mule.soap.api.rm.TerminateSequenceRequest;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.TestReliableMessagingProperties;
import org.mule.soap.runtime.rm.RMExecutionTestCase;
import org.mule.soap.runtime.rm.store.RmStoreImpTestCase;
import org.mule.soap.service.RM11Service;
import org.mule.soap.service.RM12Service;
import org.mule.soap.transport.TestHttpDispatcher;

public class RMExecutionWithStoreTestCase
extends AbstractSoapServiceTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static final String WSRM_200502 = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSA_200408 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WSRM_10 = "http://schemas.xmlsoap.org/ws/2005/02/rm";
    private static final String WSA_10 = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private RMExecutionTestCase.TestRMHttpDispatcher rmDispatcher;
    private RmStoreImpTestCase.TestReliableMessagingStore testReliableMessagingStore = new RmStoreImpTestCase.TestReliableMessagingStore();

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? RM11Service.class.getName() : RM12Service.class.getName();
    }

    @Override
    protected void doBefore() throws Exception {
        this.rmDispatcher = new RMExecutionTestCase.TestRMHttpDispatcher(new TestHttpDispatcher());
        this.testReliableMessagingStore.clear();
    }

    @Test
    public void executeTwoOperationWithTheSameSequenceIdUsingAnObjectStore() throws Exception {
        ReliableMessagingConfiguration reliableMessaging = ReliableMessagingConfiguration.builder().store((ReliableMessagingStore)this.testReliableMessagingStore).build();
        TestSoapClient client = this.createClient(reliableMessaging);
        String sequenceId = client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").build(), this.rmDispatcher);
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(this.rmDispatcher.getCount() - 1).endsWith("CreateSequence"));
        client.consume((SoapRequest)SoapRequest.builder().operation("sayHi").content("<con:sayHi xmlns:con=\"http://service.connectors.mule.org/\"><arg0>Gabriel</arg0></con:sayHi>").reliableMessagingProperties((ReliableMessagingProperties)new TestReliableMessagingProperties(sequenceId)).build(), this.rmDispatcher);
        SoapTestUtils.assertContainsXml(this.wsrmSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId, 1), this.rmDispatcher.getRequestContent());
        TestSoapClient client2 = this.createClient(reliableMessaging);
        client2.consume((SoapRequest)SoapRequest.builder().operation("sayHi").content("<con:sayHi xmlns:con=\"http://service.connectors.mule.org/\"><arg0>Gabriel</arg0></con:sayHi>").reliableMessagingProperties((ReliableMessagingProperties)new TestReliableMessagingProperties(sequenceId)).build(), this.rmDispatcher);
        SoapTestUtils.assertContainsXml(this.wsrmSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId, 2), this.rmDispatcher.getRequestContent());
        client2.terminateSequence(TerminateSequenceRequest.builder().sequenceIdentifier(sequenceId).build(), this.rmDispatcher);
        Assert.assertEquals((long)4L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(this.rmDispatcher.getCount() - 1).endsWith("TerminateSequence"));
        SoapTestUtils.assertContainsXml(this.terminateSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId), this.rmDispatcher.getRequestContent());
    }

    @Test
    public void executeTwoOperationWithTheSameSequenceIdUsingAnObjectStoreAndDifferentClients() throws Exception {
        ReliableMessagingConfiguration reliableMessaging = ReliableMessagingConfiguration.builder().store((ReliableMessagingStore)this.testReliableMessagingStore).build();
        TestSoapClient client = this.createClient(reliableMessaging);
        String sequenceId = client.createSequence(CreateSequenceRequest.builder().namespaceUri("http://schemas.xmlsoap.org/ws/2005/02/rm").addressingNamespaceUri("http://schemas.xmlsoap.org/ws/2004/08/addressing").build(), this.rmDispatcher);
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(this.rmDispatcher.getCount() - 1).endsWith("CreateSequence"));
        client.destroy();
        client = this.createClient(reliableMessaging);
        client.consume((SoapRequest)SoapRequest.builder().operation("sayHi").content("<con:sayHi xmlns:con=\"http://service.connectors.mule.org/\"><arg0>Gabriel</arg0></con:sayHi>").reliableMessagingProperties((ReliableMessagingProperties)new TestReliableMessagingProperties(sequenceId)).build(), this.rmDispatcher);
        SoapTestUtils.assertContainsXml(this.wsrmSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId, 1), this.rmDispatcher.getRequestContent());
        client.destroy();
        client = this.createClient(reliableMessaging);
        client.consume((SoapRequest)SoapRequest.builder().operation("sayHi").content("<con:sayHi xmlns:con=\"http://service.connectors.mule.org/\"><arg0>Gabriel</arg0></con:sayHi>").reliableMessagingProperties((ReliableMessagingProperties)new TestReliableMessagingProperties(sequenceId)).build(), this.rmDispatcher);
        SoapTestUtils.assertContainsXml(this.wsrmSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId, 2), this.rmDispatcher.getRequestContent());
        client.destroy();
        client = this.createClient(reliableMessaging);
        client.terminateSequence(TerminateSequenceRequest.builder().sequenceIdentifier(sequenceId).build(), this.rmDispatcher);
        Assert.assertEquals((long)4L, (long)this.rmDispatcher.getCount());
        Assert.assertTrue((boolean)this.rmDispatcher.getActions().get(this.rmDispatcher.getCount() - 1).endsWith("TerminateSequence"));
        SoapTestUtils.assertContainsXml(this.terminateSequenceStringToAssert("http://schemas.xmlsoap.org/ws/2005/02/rm", "http://schemas.xmlsoap.org/ws/2004/08/addressing", sequenceId), this.rmDispatcher.getRequestContent());
    }

    private TestSoapClient createClient(ReliableMessagingConfiguration reliableMessaging) {
        return new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).enableMtom(this.isMtom()).withVersion(this.soapVersion).withSecurities(this.getSecurityStrategies()).withReliableMessaging(reliableMessaging).build());
    }

    private String wsrmSequenceStringToAssert(String namespace, String addressingNamespace, String sequenceId, int messageNumber) {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? this.wsrmSequenceStringSoap11ToAssert(namespace, addressingNamespace, sequenceId, messageNumber) : this.wsrmSequenceStringSoap12ToAssert(namespace, addressingNamespace, sequenceId, messageNumber);
    }

    private String wsrmSequenceStringSoap11ToAssert(String namespace, String addressingNamespace, String sequenceId, int messageNumber) {
        return "<wsrm:Sequence soap:mustUnderstand=\"1\" xmlns:ns2=\"" + addressingNamespace + "\" xmlns:wsrm=\"" + namespace + "\"><wsrm:Identifier>" + sequenceId + "</wsrm:Identifier><wsrm:MessageNumber>" + messageNumber + "</wsrm:MessageNumber></wsrm:Sequence>";
    }

    private String terminateSequenceStringToAssert(String namespace, String addressingNamespace, String sequenceId) {
        return "<wsrm:TerminateSequence xmlns:wsrm=\"" + namespace + "\" xmlns:ns2=\"" + addressingNamespace + "\">" + this.sequenceIdentifierStringToAssert(sequenceId) + "</wsrm:TerminateSequence>";
    }

    private String sequenceIdentifierStringToAssert(String sequenceId) {
        return "<wsrm:Identifier>" + sequenceId + "</wsrm:Identifier>";
    }

    private String wsrmSequenceStringSoap12ToAssert(String namespace, String addressingNamespace, String sequenceId, int messageNumber) {
        return "<wsrm:Sequence soap:mustUnderstand=\"true\" xmlns:ns2=\"" + addressingNamespace + "\" xmlns:wsrm=\"" + namespace + "\"><wsrm:Identifier>" + sequenceId + "</wsrm:Identifier><wsrm:MessageNumber>" + messageNumber + "</wsrm:MessageNumber></wsrm:Sequence>";
    }
}

