/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor;

import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.internal.client.AbstractSoapCxfClient;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;

import static java.lang.String.CASE_INSENSITIVE_ORDER;
import static org.apache.cxf.message.Message.CONTENT_TYPE;
import static org.mule.soap.internal.interceptor.SoapActionInterceptor.SOAP_ACTION;

/**
 * Creates {@link TransportRequest} instances given a {@link Message}.
 *
 * @since 1.1
 */
public class TransportRequestFactory {

  public static TransportRequest createDispatchingRequest(Message message) {
    Exchange exchange = message.getExchange();
    String action = (String) exchange.get(AbstractSoapCxfClient.MULE_SOAP_ACTION);
    Map<String, String> headers = new TreeMap<>(CASE_INSENSITIVE_ORDER);
    headers.put(SOAP_ACTION, action);
    // It's important that content type is bundled with the headers
    headers.put(CONTENT_TYPE, (String) message.get(CONTENT_TYPE));
    headers.putAll((Map) exchange.get(AbstractSoapCxfClient.MULE_TRANSPORT_HEADERS_KEY));
    InputStream content = new ByteArrayInputStream(message.getContent(OutputStream.class).toString().getBytes());
    return new TransportRequest(content, (String) exchange.get(AbstractSoapCxfClient.MULE_WSC_ADDRESS), headers);
  }
}
