/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.server;

import java.util.Collections;
import javax.servlet.Servlet;
import javax.xml.ws.Endpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HttpServer {
    final Server httpServer;
    private final String defaultAddress;
    private final Interceptor in;
    private final Interceptor out;
    private final Object serviceInstance;

    public HttpServer(int port, Interceptor in, Interceptor out, Object serviceInstance) {
        this.httpServer = new Server(port);
        this.defaultAddress = "http://localhost:" + port + "/server";
        this.in = in;
        this.out = out;
        this.serviceInstance = serviceInstance;
        this.init();
    }

    protected void init() {
        try {
            ServletHandler servletHandler = new ServletHandler();
            this.httpServer.setHandler((Handler)servletHandler);
            CXFNonSpringServlet cxf = new CXFNonSpringServlet();
            ServletHolder servlet = new ServletHolder((Servlet)cxf);
            servlet.setName("server");
            servlet.setForcedPath("/");
            servletHandler.addServletWithMapping(servlet, "/*");
            this.initializeServer(cxf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void initializeServer(CXFNonSpringServlet cxf) {
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Bus bus = cxf.getBus();
        bus.setProperties(Collections.singletonMap(".level", "ERROR"));
        if (this.in != null) {
            bus.getInInterceptors().add(this.in);
        }
        if (this.out != null) {
            bus.getOutInterceptors().add(this.out);
        }
        BusFactory.setDefaultBus((Bus)bus);
        Endpoint.publish((String)"/server", (Object)this.serviceInstance);
    }

    public void stop() throws Exception {
        this.httpServer.stop();
        this.httpServer.destroy();
    }

    public String getDefaultAddress() {
        return this.defaultAddress;
    }
}

