/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.unit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.internal.interceptor.TransportRequestFactory;

public class DispatchingRequestFactoryTestCase {
    private static final String CONTENT = "<a>content</a>";
    private static final String SOAP_ACTION_VALUE = "noOPE";

    @Test
    public void checkOverrideDefaultHeaders() throws IOException {
        Message messageMock = this.getMessageMock();
        TransportRequest dispatchingRequest = TransportRequestFactory.createDispatchingRequest((Message)messageMock);
        Assert.assertThat(dispatchingRequest.getHeader("SOAPAction").get(), (Matcher)Is.is((Object)SOAP_ACTION_VALUE));
    }

    private Message getMessageMock() throws IOException {
        Exchange exchangeMock = (Exchange)Mockito.mock(Exchange.class);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.write(CONTENT.getBytes());
        Mockito.when((Object)exchangeMock.get((Object)"mule.soap.transport.headers")).thenReturn(Collections.singletonMap("SOAPAction".toLowerCase(), SOAP_ACTION_VALUE));
        Message messageMock = (Message)Mockito.mock(Message.class);
        Mockito.when((Object)messageMock.getContent(OutputStream.class)).thenReturn((Object)os);
        Mockito.when((Object)messageMock.getExchange()).thenReturn((Object)exchangeMock);
        return messageMock;
    }
}

