/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.interceptor.Interceptor;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.soap.SoapTestXmlValues;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.server.FreePortFinder;
import org.mule.soap.server.HttpServer;
import org.mule.soap.service.Soap11Service;
import org.mule.soap.service.Soap12Service;

@RunWith(value=Parameterized.class)
public abstract class AbstractSoapServiceTestCase {
    public final SoapTestXmlValues testValues = new SoapTestXmlValues("http://service.soap.mule.org/");
    public FreePortFinder portFinder = new FreePortFinder(8000, 30000);
    @Parameterized.Parameter
    public SoapVersion soapVersion;
    @Parameterized.Parameter(value=1)
    public String serviceClass;
    protected TestSoapClient client;
    protected HttpServer server;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({SoapVersion.SOAP_11, Soap11Service.class.getName()}, {SoapVersion.SOAP_12, Soap12Service.class.getName()});
    }

    @Before
    public void before() throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        this.server = new HttpServer(this.portFinder.find(), this.buildInInterceptor(), this.buildOutInterceptor(), this.createServiceInstance());
        this.client = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).enableMtom(this.isMtom()).withVersion(this.soapVersion).withSecurities(this.getSecurityStrategies()).build());
    }

    protected boolean isMtom() {
        return false;
    }

    @After
    public void tearDown() {
        this.client.destroy();
    }

    protected List<SecurityStrategy> getSecurityStrategies() {
        return Collections.emptyList();
    }

    protected String getServiceClass() {
        return this.serviceClass;
    }

    protected Interceptor buildInInterceptor() {
        return null;
    }

    protected Interceptor buildOutInterceptor() {
        return null;
    }

    private Object createServiceInstance() throws Exception {
        Class<?> serviceClass = this.getClass().getClassLoader().loadClass(this.getServiceClass());
        return serviceClass.newInstance();
    }
}

