/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.EmptyRequestGenerator;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.mule.wsdl.parser.model.PortModel;

public final class SoapRequestGenerator {
    private final EmptyRequestGenerator emptyRequestGenerator;
    private final AttachmentRequestEnricher requestEnricher;

    public SoapRequestGenerator(AttachmentRequestEnricher requestEnricher, PortModel port) {
        this.requestEnricher = requestEnricher;
        this.emptyRequestGenerator = new EmptyRequestGenerator(port);
    }

    public XMLStreamReader generate(String operation, String body, Map<String, SoapAttachment> attachments) {
        if (StringUtils.isBlank((CharSequence)body)) {
            body = this.emptyRequestGenerator.generateRequest(operation);
        }
        if (!attachments.isEmpty()) {
            body = this.requestEnricher.enrichRequest(body, attachments);
        }
        try {
            return XmlTransformationUtils.stringToXmlStreamReader(body);
        }
        catch (XmlTransformationException e) {
            throw new BadRequestException("Error generating SOAP request", e);
        }
    }
}

