/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import java.util.Map;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.mule.soap.internal.xml.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AttachmentRequestEnricher {
    public String enrichRequest(String body, Map<String, SoapAttachment> attachments) {
        try {
            Document bodyDocument = XmlTransformationUtils.stringToDocument(body);
            Element documentElement = bodyDocument.getDocumentElement();
            attachments.forEach((name, attachment) -> {
                Element attachmentElement = bodyDocument.createElement((String)name);
                this.addAttachmentElement(bodyDocument, (String)name, (SoapAttachment)attachment, attachmentElement);
                documentElement.appendChild(attachmentElement);
            });
            return XMLUtils.toXml(bodyDocument);
        }
        catch (XmlTransformationException e) {
            throw new BadRequestException("Error while preparing request for the provided body", e);
        }
    }

    abstract void addAttachmentElement(Document var1, String var2, SoapAttachment var3, Element var4);
}

