/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Exchange;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.soap.api.exception.EncodingException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class SoapAttachmentResponseEnricher
extends AttachmentResponseEnricher {
    public SoapAttachmentResponseEnricher(List<OperationModel> operations) {
        super(operations);
    }

    @Override
    protected void processResponseAttachments(Document response, Collection<ObjectFieldType> attachments, Exchange exchange) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        attachments.forEach(attachment -> {
            String attachmentName = MetadataTypeUtils.getLocalPart((ObjectFieldType)attachment);
            builder.put((Object)attachmentName, (Object)this.getAttachment(response, attachmentName));
        });
        exchange.put((Object)"mule.soap.attachments", (Object)builder.build());
    }

    private SoapAttachment getAttachment(Document response, String name) {
        Node attachmentNode = response.getDocumentElement().getElementsByTagNameNS("*", name).item(0);
        InputStream decodedAttachment = this.decodeAttachment(name, attachmentNode.getTextContent());
        response.getDocumentElement().removeChild(attachmentNode);
        return new SoapAttachment(decodedAttachment, "*/*");
    }

    private InputStream decodeAttachment(String name, String attachmentContent) {
        try {
            return new ByteArrayInputStream(Base64.getDecoder().decode(attachmentContent));
        }
        catch (Exception e) {
            throw new EncodingException(String.format("Cannot decode base64 attachment [%s]", name));
        }
    }
}

