/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime.attachments;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.internal.message.DefaultSoapRequest;

public class AttachmentsTestCase
extends AbstractSoapServiceTestCase {
    @Test
    public void downloadAttachment() throws Exception {
        DefaultSoapRequest req = SoapRequest.builder().content(this.testValues.getDownloadAttachmentRequest()).operation("downloadAttachment").build();
        SoapResponse response = this.client.consume((SoapRequest)req, null);
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), response.getContent());
        Map attachments = response.getAttachments();
        Assert.assertThat(attachments.entrySet(), (Matcher)Matchers.hasSize((int)1));
        SoapAttachment attachment = (SoapAttachment)attachments.entrySet().iterator().next().getValue();
        Assert.assertThat((Object)IOUtils.toString((InputStream)attachment.getContent()), (Matcher)Matchers.containsString((String)"Simple Attachment Content"));
    }

    @Test
    public void uploadAttachment() throws Exception {
        DefaultSoapRequest request = SoapRequest.builder().attachment("attachment", new SoapAttachment((InputStream)new ByteArrayInputStream("Some Content".getBytes()), "text/html")).content(this.testValues.getUploadAttachmentRequest()).operation("uploadAttachment").build();
        SoapResponse response = this.client.consume((SoapRequest)request, null);
        SoapTestUtils.assertSimilarXml(this.testValues.getUploadAttachmentResponse(), response.getContent());
    }
}

