/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.cxf.message.Exchange;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public abstract class AttachmentResponseEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentResponseEnricher.class);
    private static final AtomicBoolean alreadyLoggedWarning = new AtomicBoolean();
    private final Map<String, OperationModel> operations;

    AttachmentResponseEnricher(List<OperationModel> operations) {
        this.operations = operations.stream().collect(Collectors.toMap(OperationModel::getName, Function.identity(), (op1, op2) -> {
            if (alreadyLoggedWarning.compareAndSet(false, true)) {
                LOGGER.warn("Overloaded operations with different outputs are not fully supported");
            }
            return op1;
        }));
    }

    public void enrich(Document response, String operation, Exchange exchange) {
        Collection attachmentsFields;
        MetadataType attachments = this.operations.get(operation).getOutputType().getAttachments();
        if (attachments instanceof ObjectType && !(attachmentsFields = ((ObjectType)attachments).getFields()).isEmpty()) {
            this.processResponseAttachments(response, attachmentsFields, exchange);
        }
    }

    protected abstract void processResponseAttachments(Document var1, Collection<ObjectFieldType> var2, Exchange var3);
}

