/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.generator.attachment;

import org.apache.cxf.message.Exchange;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.soap.internal.interceptor.OutputMtomSoapAttachmentsInterceptor;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import java.util.Collection;
import java.util.List;

import static org.mule.metadata.api.utils.MetadataTypeUtils.getLocalPart;

/**
 * {@link AttachmentResponseEnricher} implementation for clients that works with MTOM.
 *
 * @since 1.0
 */
public final class MtomResponseEnricher extends AttachmentResponseEnricher {

  public MtomResponseEnricher(List<OperationModel> operations) {
    super(operations);
  }

  /**
   * {@inheritDoc}
   * <p>
   * Removes the attachments nodes from the response that have been already processed by the
   * {@link OutputMtomSoapAttachmentsInterceptor}
   */
  @Override
  protected void processResponseAttachments(Document response, Collection<ObjectFieldType> attachments, Exchange exchange) {
    attachments.forEach(a -> {
      String tagName = getLocalPart(a);
      Node attachmentNode = response.getDocumentElement().getElementsByTagNameNS("*", tagName).item(0);
      response.getDocumentElement().removeChild(attachmentNode);
    });
  }
}
