/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.transport;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.api.transport.TransportResponse;

public class TestHttpDispatcher
implements TransportDispatcher {
    public TransportResponse dispatch(TransportRequest request) {
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httppost = new HttpPost(request.getAddress());
            request.getHeaders().forEach((arg_0, arg_1) -> ((HttpPost)httppost).addHeader(arg_0, arg_1));
            httppost.setEntity((HttpEntity)new InputStreamEntity(request.getContent()));
            HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
            HttpEntity entity = response.getEntity();
            Map<String, String> headers = Stream.of(response.getAllHeaders()).collect(Collectors.toMap(h -> h.getName(), h -> h.getValue()));
            HashMap<String, String> statusLine = new HashMap<String, String>();
            statusLine.put("statusCode", String.valueOf(response.getStatusLine().getStatusCode()));
            statusLine.put("reasonPhrase", response.getStatusLine().getReasonPhrase());
            statusLine.put("protocolVersion", response.getStatusLine().getProtocolVersion().toString());
            return new TransportResponse(entity.getContent(), headers, statusLine);
        }
        catch (Exception e) {
            throw new RuntimeException("Error dispatching", e);
        }
    }
}

