/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.unit;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;
import org.mule.soap.internal.generator.attachment.MtomRequestEnricher;
import org.mule.soap.internal.generator.attachment.SoapAttachmentRequestEnricher;

public class AttachmentsRequestEnricherTestCase {
    private static final String FILE_NAME = "attachment.txt";
    private static final String FILE_CONTENT = "My simple attachment";
    private static final String CID = "cid:attachment.txt";
    private static final String FILE_CONTENT_BASE64 = "TXkgc2ltcGxlIGF0dGFjaG1lbnQ=";
    private static final String BODY = "<root><file>cid:attachment.txt</file></root>";
    AttachmentRequestEnricher mtomEnricher = new MtomRequestEnricher();
    AttachmentRequestEnricher soapEnricher = new SoapAttachmentRequestEnricher();

    @Test
    public void handleMtomAttachments() {
        String enrichedBody = this.mtomEnricher.enrichRequest(BODY, this.getAttachments(FILE_NAME, FILE_CONTENT));
        enrichedBody = enrichedBody.replace("\\\\s", "");
        Assert.assertThat((Object)enrichedBody, (Matcher)CoreMatchers.containsString((String)BODY.replace(CID, "<xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:attachment.txt\"/>")));
    }

    @Test
    public void handleSoapAttachmentsInBase64() throws Exception {
        String enrichedBody = this.soapEnricher.enrichRequest(BODY, this.getAttachments(FILE_NAME, FILE_CONTENT));
        Assert.assertThat((Object)enrichedBody, (Matcher)CoreMatchers.containsString((String)BODY.replace(CID, FILE_CONTENT_BASE64)));
    }

    @Test
    public void handleSoapAttachmentsIfNoCIDInPayload() throws Exception {
        String enrichedBody = this.soapEnricher.enrichRequest(BODY, this.getAttachments("INVALID_FILENAME", FILE_CONTENT));
        Assert.assertThat((Object)enrichedBody, (Matcher)CoreMatchers.containsString((String)BODY.replace("</root>", "<INVALID_FILENAME>TXkgc2ltcGxlIGF0dGFjaG1lbnQ=</INVALID_FILENAME></root>")));
    }

    @Test
    public void handleMtomAttachmentsIfNoCIDInPayload() throws Exception {
        String enrichedBody = this.mtomEnricher.enrichRequest(BODY, this.getAttachments("INVALID_FILENAME", FILE_CONTENT));
        Assert.assertThat((Object)enrichedBody, (Matcher)CoreMatchers.containsString((String)BODY.replace("</root>", "<INVALID_FILENAME><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:INVALID_FILENAME\"/></INVALID_FILENAME></root>")));
    }

    private Map<String, SoapAttachment> getAttachments(String name, String content) {
        return Collections.singletonMap(name, new SoapAttachment((InputStream)new ByteArrayInputStream(content.getBytes()), "text/plain"));
    }
}

