/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import java.util.Map;
import java.util.Optional;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.mule.soap.internal.xml.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AttachmentRequestEnricher {
    private static final String TEXT_XPATH_MASK = "//*[normalize-space()='cid:%s']/text()";

    public String enrichRequest(String body, Map<String, SoapAttachment> attachments) {
        try {
            Document bodyDocument = XmlTransformationUtils.stringToDocument(body);
            Element documentElement = bodyDocument.getDocumentElement();
            attachments.forEach((name, attachment) -> {
                Optional<Node> placeholderNode = this.getAttachmentPlaceholderNode(bodyDocument, (String)name);
                Node attachmentNode = this.createAttachmentNode(bodyDocument, (String)name, (SoapAttachment)attachment);
                if (placeholderNode.isPresent()) {
                    Node placeholder = placeholderNode.get();
                    placeholder.getParentNode().replaceChild(attachmentNode, placeholder);
                } else {
                    Element attachmentElement = bodyDocument.createElement((String)name);
                    attachmentElement.appendChild(attachmentNode);
                    documentElement.appendChild(attachmentElement);
                }
            });
            return XMLUtils.toXml(bodyDocument);
        }
        catch (XmlTransformationException e) {
            throw new BadRequestException("Error while preparing request for the provided body", e);
        }
    }

    protected Optional<Node> getAttachmentPlaceholderNode(Document bodyDocument, String name) {
        NodeList textNodes = XMLUtils.getElements(String.format(TEXT_XPATH_MASK, name), bodyDocument);
        return Optional.ofNullable(textNodes.getLength() != 0 ? textNodes.item(0) : null);
    }

    abstract Node createAttachmentNode(Document var1, String var2, SoapAttachment var3);
}

