/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.security.stores;

import org.apache.wss4j.common.crypto.Merlin;

import java.util.Properties;

import static org.apache.wss4j.common.crypto.Merlin.TRUSTSTORE_FILE;
import static org.apache.wss4j.common.crypto.Merlin.TRUSTSTORE_PASSWORD;
import static org.apache.wss4j.common.crypto.Merlin.TRUSTSTORE_TYPE;


/**
 * Default {@link WssStoreConfiguration} implementation for Trust Stores, used for signature verification.
 *
 * @since 1.0
 */
public class WssTrustStoreConfiguration implements WssStoreConfiguration {

  private String trustStorePath;
  private String password;
  private String type;

  public WssTrustStoreConfiguration(String trustStorePath, String password, String type) {
    this.trustStorePath = trustStorePath;
    this.password = password;
    this.type = type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Properties getConfigurationProperties() {
    Properties properties = new Properties();
    properties.setProperty(WS_CRYPTO_PROVIDER_KEY, Merlin.class.getCanonicalName());
    properties.setProperty(MERLIN_PROP_PREFIX + TRUSTSTORE_FILE, trustStorePath);
    properties.setProperty(MERLIN_PROP_PREFIX + TRUSTSTORE_TYPE, type);
    properties.setProperty(MERLIN_PROP_PREFIX + TRUSTSTORE_PASSWORD, password);
    return properties;
  }
}
