/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.xml.util;

import com.sun.org.apache.xpath.internal.NodeSet;
import org.dom4j.io.DOMReader;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import static java.lang.String.format;
import static javax.xml.xpath.XPathConstants.NODESET;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * General utility methods for working with XML.
 * 
 * @since 1.0, Copied from the removed XML module.
 */
public class XMLUtils {

  /**
   * Converts a DOM to an XML string.
   * 
   * @param dom the dome object to convert
   * @return A string representation of the document
   */
  public static String toXml(Document dom) {
    return new DOMReader().read(dom).asXML();
  }

  public static NodeList getElements(String xpathExpr, Document document) {
    try {
      XPathFactory xPathfactory = XPathFactory.newInstance();
      XPath xpath = xPathfactory.newXPath();

      if (!isBlank(xpathExpr)) {
        XPathExpression expr = xpath.compile(xpathExpr);
        return (NodeList) expr.evaluate(document, NODESET);
      } else {
        return new NodeSet(document.getDocumentElement());
      }
    } catch (XPathExpressionException e) {
      throw new RuntimeException(format("Error evaluating Xpath expression '%s'", xpathExpr), e);
    }
  }
}
