/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap;

import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class SoapTestUtils {
    public static void assertSimilarXml(String expected, String result) throws Exception {
        XMLUnit.setIgnoreWhitespace((boolean)true);
        Diff diff = XMLUnit.compareXML((String)result, (String)expected);
        if (!diff.similar()) {
            System.out.println("Expected xml is:\n");
            System.out.println(SoapTestUtils.prettyPrint(expected));
            System.out.println("########################################\n");
            System.out.println("But got:\n");
            System.out.println(SoapTestUtils.prettyPrint(result));
        }
        Assert.assertThat((Object)diff.similar(), (Matcher)Is.is((Object)true));
    }

    public static void assertSimilarXml(String expected, InputStream result) throws Exception {
        SoapTestUtils.assertSimilarXml(expected, IOUtils.toString((InputStream)result));
    }

    private static String prettyPrint(String a) throws Exception {
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(a));
        Document doc = db.parse(is);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(doc);
        transformer.transform(source, result);
        return result.getWriter().toString();
    }
}

