/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.util;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.jaxp.SaxonTransformerFactory;
import org.mule.soap.internal.util.XmlTransformationException;
import org.mule.soap.internal.xml.stax.StaxSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XmlTransformationUtils {
    private static final XMLInputFactory XML_INPUT_FACTORY = XmlTransformationUtils.getXmlInputFactory();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = XmlTransformationUtils.getDocumentBuilderFactory();
    private static final TransformerFactory SAXON_TRANSFORMER_FACTORY = SaxonTransformerFactory.newInstance();

    private static DocumentBuilderFactory getDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory;
    }

    private static XMLInputFactory getXmlInputFactory() {
        XMLInputFactory xmlInputFactory = WstxInputFactory.newInstance();
        xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", false);
        return xmlInputFactory;
    }

    public static Document xmlStreamReaderToDocument(XMLStreamReader xmlStreamReader) throws XmlTransformationException {
        StaxSource staxSource = new StaxSource(xmlStreamReader);
        DOMResult writer = new DOMResult();
        try {
            Transformer transformer = SAXON_TRANSFORMER_FACTORY.newTransformer();
            transformer.transform((Source)((Object)staxSource), writer);
        }
        catch (TransformerException e) {
            throw new XmlTransformationException("Error transforming reader to DOM document", e);
        }
        return (Document)writer.getNode();
    }

    public static InputStream documentToInputStream(Document document) throws XmlTransformationException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DOMSource xmlSource = new DOMSource(document);
            StreamResult outputTarget = new StreamResult(outputStream);
            SAXON_TRANSFORMER_FACTORY.newTransformer().transform(xmlSource, outputTarget);
            return new ByteArrayInputStream(outputStream.toByteArray());
        }
        catch (TransformerException e) {
            throw new XmlTransformationException("Error transforming Document to Stream", e);
        }
    }

    public static Element stringToDomElement(String xml) throws XmlTransformationException {
        try {
            DocumentBuilder db = DOC_BUILDER_FACTORY.newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(xml));
            return db.parse(is).getDocumentElement();
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform xml string to Dom Element", e);
        }
    }

    public static Document stringToDocument(String xml) throws XmlTransformationException {
        try {
            DocumentBuilder builder = DOC_BUILDER_FACTORY.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform xml to Dom Document", e);
        }
    }

    public static String nodeToString(Node node) throws XmlTransformationException {
        try {
            StringWriter writer = new StringWriter();
            DOMSource source = new DOMSource(node);
            StreamResult result = new StreamResult(writer);
            Transformer transformer = SAXON_TRANSFORMER_FACTORY.newTransformer();
            transformer.transform(source, result);
            return writer.toString();
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform Node to String", e);
        }
    }

    public static XMLStreamReader stringToXmlStreamReader(String xml) throws XmlTransformationException {
        return XmlTransformationUtils.stringToXmlStreamReader(xml, "UTF-8");
    }

    public static XMLStreamReader stringToXmlStreamReader(String xml, String encoding) throws XmlTransformationException {
        try {
            return XML_INPUT_FACTORY.createXMLStreamReader(new ByteArrayInputStream(xml.getBytes(Charset.forName(encoding))));
        }
        catch (Exception e) {
            throw new XmlTransformationException("Could not transform xml to XmlStreamReader", e);
        }
    }
}

