/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.client;

import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportDispatcher;

/**
 * Contract for clients that consumes SOAP Web Services.
 *
 * @since 1.0
 */
public interface SoapClient {

  /**
   * Sends a {@link SoapRequest} blocking the current thread until a response is available or the request times out.
   *
   * @param request a {@link SoapRequest} instance.
   * @param dispatcher a {@link TransportDispatcher} that will be used to dispatch the {@link SoapRequest}
   * @return a {@link SoapResponse} instance with the XML content and Headers if any.
   */
  SoapResponse consume(SoapRequest request, TransportDispatcher dispatcher) throws BadRequestException, BadResponseException;

  /**
   * Shuts down the client and all resources that is holding.
   */
  void destroy();

}
