/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.cxf.message.Exchange;
import org.mule.soap.api.exception.EncodingException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.wsdl.parser.model.operation.OperationModel;

public final class SoapAttachmentResponseEnricher
extends AttachmentResponseEnricher {
    public SoapAttachmentResponseEnricher(List<OperationModel> operations) {
        super(operations);
    }

    @Override
    protected void processAttachmentData(String attachmentName, String attachmentData, Exchange exchange) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        if (exchange.get((Object)"mule.soap.attachments") != null) {
            builder.putAll((Map)exchange.get((Object)"mule.soap.attachments"));
        }
        builder.put((Object)attachmentName, (Object)this.buildAttachment(attachmentName, attachmentData));
        exchange.put((Object)"mule.soap.attachments", (Object)builder.build());
    }

    private SoapAttachment buildAttachment(String attachmentName, String attachmentData) {
        InputStream decodedAttachment = this.decodeAttachment(attachmentName, attachmentData);
        return new SoapAttachment(decodedAttachment, "*/*");
    }

    private InputStream decodeAttachment(String name, String attachmentContent) {
        try {
            return new ByteArrayInputStream(Base64.getDecoder().decode(attachmentContent));
        }
        catch (Exception e) {
            throw new EncodingException(String.format("Cannot decode base64 attachment [%s]", name));
        }
    }
}

