package org.mule.soap.api;

/**
 * The versions of the SOAP protocol.
 *
 * @since 1.0
 */
public enum SoapVersion {

  SOAP_11("1.1", "SOAP 1.1 Protocol"), SOAP_12("1.2", "SOAP 1.2 Protocol");

  private final String version;
  private final String protocol;

  SoapVersion(String version, String protocol) {
    this.version = version;
    this.protocol = protocol;
  }

  public String getNumber() {
    return this.version;
  }

  public String getProtocol() {
    return this.protocol;
  }
}
