/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.junit.Before;
import org.junit.Test;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.generator.attachment.MtomResponseEnricher;

public class MtomResponseEnricherTestCase
extends AbstractEnricherTestCase {
    private AttachmentResponseEnricher enricher;

    @Override
    @Before
    public void setup() {
        super.setup();
        List ops = this.model.getService("TestService").getPort("TestPort").getOperations();
        this.enricher = new MtomResponseEnricher(ops);
    }

    @Test
    public void enrich() throws Exception {
        String result;
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:attachment-id\"/></attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        try (InputStream enrichedResponse = this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);){
            result = IOUtils.toString((InputStream)enrichedResponse, (Charset)StandardCharsets.UTF_8);
        }
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
    }
}

