/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.mule.soap.api.client.BadRequestException;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.exception.SoapFaultException;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.DispatcherException;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.internal.generator.SoapRequestGenerator;
import org.mule.soap.internal.generator.SoapResponseGenerator;
import org.mule.soap.internal.generator.attachment.AttachmentRequestEnricher;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.util.XmlTransformationUtils;
import org.mule.wsdl.parser.exception.OperationNotFoundException;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.OperationType;

public abstract class AbstractSoapCxfClient
implements SoapClient {
    public static final String MESSAGE_DISPATCHER = "mule.soap.dispatcher";
    public static final String MULE_ATTACHMENTS_KEY = "mule.soap.attachments";
    public static final String MULE_WSC_ADDRESS = "mule.soap.address";
    public static final String MULE_HEADERS_KEY = "mule.soap.headers";
    public static final String MULE_TRANSPORT_HEADERS_KEY = "mule.soap.transport.headers";
    public static final String MULE_TRANSPORT_ADDITIONAL_DATA_KEY = "mule.soap.transport.additionalData";
    public static final String MULE_SOAP_ACTION = "mule.soap.action";
    public static final String MULE_SOAP_OPERATION_STYLE = "mule.soap.operation.type";
    private final SoapRequestGenerator requestGenerator;
    private final SoapResponseGenerator responseGenerator;
    private final Client client;
    private final WsdlModel wsdlModel;
    private final PortModel port;
    private final String address;
    private final String encoding;

    AbstractSoapCxfClient(Client client, WsdlModel wsdlModel, PortModel portModel, String address, String encoding, AttachmentRequestEnricher requestEnricher, AttachmentResponseEnricher responseEnricher) {
        this.client = client;
        this.wsdlModel = wsdlModel;
        this.port = portModel;
        this.address = address;
        this.encoding = encoding;
        this.requestGenerator = new SoapRequestGenerator(requestEnricher, portModel);
        this.responseGenerator = new SoapResponseGenerator(responseEnricher);
    }

    @Override
    public SoapResponse consume(SoapRequest request, TransportDispatcher dispatcher) {
        Objects.requireNonNull(dispatcher, "Message Dispatcher cannot be null");
        String operation = request.getOperation();
        ExchangeImpl exchange = new ExchangeImpl();
        Object[] response = this.invoke(request, (Exchange)exchange, dispatcher);
        return this.responseGenerator.generate(operation, response, (Exchange)exchange);
    }

    @Override
    public void destroy() {
        this.client.destroy();
    }

    private Object[] invoke(SoapRequest request, Exchange exchange, TransportDispatcher dispatcher) {
        String ope = request.getOperation();
        XMLStreamReader xmlBody = this.getXmlBody(request);
        try {
            Map<String, Object> ctx = this.getInvocationContext(request, dispatcher);
            return this.client.invoke(this.getInvocationOperation(ope), new Object[]{xmlBody}, ctx, exchange);
        }
        catch (SoapFault sf) {
            throw new SoapFaultException(sf);
        }
        catch (Fault f) {
            if (f.getMessage().contains("COULD_NOT_READ_XML")) {
                throw new BadRequestException("Error consuming the operation [" + ope + "], the request body is not a valid XML");
            }
            throw new SoapFaultException(f);
        }
        catch (OperationNotFoundException e) {
            String errorMsg = "The provided operation [" + ope + "] does not exist in the WSDL file [" + this.wsdlModel.getLocation() + "]";
            throw new BadRequestException(errorMsg, e);
        }
        catch (DispatcherException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while consuming the web service operation [" + ope + "]", e);
        }
    }

    private XMLStreamReader getXmlBody(SoapRequest request) {
        return this.requestGenerator.generate(request.getOperation(), request.getContent(), this.getEncoding(request), request.getAttachments());
    }

    private BindingOperationInfo getInvocationOperation(String operationName) {
        Endpoint ep = this.client.getEndpoint();
        String method = this.port.getOperation(operationName).getType().equals((Object)OperationType.ONE_WAY) ? "invokeOneWay" : "invoke";
        QName q = new QName(ep.getService().getName().getNamespaceURI(), method);
        BindingOperationInfo bop = ep.getBinding().getBindingInfo().getOperation(q);
        if (bop.isUnwrappedCapable()) {
            bop = bop.getUnwrappedOperation();
        }
        return bop;
    }

    private Map<String, Object> getInvocationContext(SoapRequest request, TransportDispatcher dispatcher) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        OperationModel operation = this.port.getOperation(request.getOperation());
        props.put(MULE_ATTACHMENTS_KEY, this.buildCxfAttachments(request.getAttachments()));
        props.put(MULE_WSC_ADDRESS, this.address);
        props.put(Message.ENCODING, this.getEncoding(request));
        props.put(MULE_HEADERS_KEY, this.buildCxfHeaders(request.getSoapHeaders()));
        props.put(MULE_TRANSPORT_HEADERS_KEY, request.getTransportHeaders());
        props.put(MESSAGE_DISPATCHER, dispatcher);
        props.put(MULE_SOAP_OPERATION_STYLE, this.port.getOperation(request.getOperation()).getType());
        String soapAction = operation.getSoapAction();
        if (soapAction != null) {
            props.put(MULE_SOAP_ACTION, soapAction);
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("RequestContext", props);
        return ctx;
    }

    private String getEncoding(SoapRequest request) {
        try {
            return new ContentType(request.getContentType()).getParameter("charset");
        }
        catch (ParseException e) {
            return StringUtils.isBlank((CharSequence)this.encoding) ? "UTF-8" : this.encoding;
        }
    }

    protected abstract Map<String, Attachment> buildCxfAttachments(Map<String, SoapAttachment> var1);

    private List<SoapHeader> buildCxfHeaders(Map<String, String> headers) {
        if (headers == null) {
            return Collections.emptyList();
        }
        return headers.entrySet().stream().map(header -> {
            try {
                return new SoapHeader(new QName(null, (String)header.getKey()), (Object)XmlTransformationUtils.stringToDomElement((String)header.getValue()));
            }
            catch (Exception e) {
                throw new BadRequestException("Cannot parse input header [" + (String)header.getKey() + "]", e);
            }
        }).collect(Collectors.toList());
    }
}

