/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.client;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.message.Attachment;

import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.attachment.SoapAttachmentRequestEnricher;
import org.mule.soap.internal.generator.attachment.SoapAttachmentResponseEnricher;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.WsdlModel;

import java.util.Map;

import static java.util.Collections.emptyMap;

/**
 * a {@link SoapClient} implementation based on CXF.
 *
 * @since 1.0
 */
public class DefaultSoapCxfClient extends AbstractSoapCxfClient {

  DefaultSoapCxfClient(Client client,
                       WsdlModel wsdl,
                       PortModel port,
                       String address,
                       String encoding) {
    super(client, wsdl, port, address, encoding,
          new SoapAttachmentRequestEnricher(),
          new SoapAttachmentResponseEnricher(port.getOperations()));
  }

  @Override
  protected Map<String, Attachment> buildCxfAttachments(Map<String, SoapAttachment> attachments) {
    // Attachments are embedded in the request
    return emptyMap();
  }
}
