package org.mule.soap.internal.util;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.soap.api.SoapVersion;
import org.mule.wsdl.parser.model.FaultModel;
import org.mule.wsdl.parser.model.message.MessageDefinition;
import org.mule.wsdl.parser.model.message.MessagePart;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.mule.wsdl.parser.model.operation.OperationType;
import org.mule.wsdl.parser.model.operation.Type;

import java.util.ArrayList;
import java.util.List;

import static java.util.Collections.unmodifiableList;

public final class OperationModelUtils {

  private static List<FaultModel> emptyFaults = unmodifiableList(new ArrayList<>());
  private static List<MessagePart> emptyParts = unmodifiableList(new ArrayList<>());
  private static BaseTypeBuilder builder = new BaseTypeBuilder(MetadataFormat.XML);
  private static MetadataType nullMetadataType = builder.nullType().build();
  private static MessageDefinition message = new MessageDefinition("", emptyParts);
  private static Type nullType = new Type(nullMetadataType, nullMetadataType, nullMetadataType, message);

  public static OperationModel from(String name, SoapVersion version) {
    return new OperationModel(name, nullType, nullType, OperationType.REQUEST_RESPONSE, null, emptyFaults, getVersion(version));
  }

  private static org.mule.wsdl.parser.model.version.SoapVersion getVersion(SoapVersion version) {
    return version == SoapVersion.SOAP_11
        ? org.mule.wsdl.parser.model.version.SoapVersion.SOAP11
        : org.mule.wsdl.parser.model.version.SoapVersion.SOAP12;
  }

  private OperationModelUtils() {}
}
