/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.util;

import org.mule.wsdl.parser.exception.OperationNotFoundException;
import org.mule.wsdl.parser.model.operation.OperationModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static java.lang.String.format;

public class OperationResolver {

  private final List<Map<String, OperationModel>> list = new ArrayList<>();

  public OperationResolver(Map<String, OperationModel> operations) {
    add(operations);
  }

  public void add(Map<String, OperationModel> operations) {
    this.list.add(operations);
  }

  public OperationModel resolve(String operation) {
    for (Map<String, OperationModel> operations : list) {
      if (operations.containsKey(operation)) {
        return operations.get(operation);
      }
    }
    throw new OperationNotFoundException(format("operation [%s] was not found", operation));
  }
}
