/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.client;

import org.junit.rules.ExternalResource;
import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.api.SoapWebServiceConfigurationBuilder;
import org.mule.soap.api.client.BadResponseException;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.api.transport.TransportDispatcher;
import org.mule.soap.api.transport.TransportResponse;
import org.mule.soap.internal.client.SoapCxfClientFactory;
import org.mule.soap.transport.TestHttpDispatcher;

public class TestSoapClient
extends ExternalResource
implements SoapClient {
    private static final String DEFAULT_TEST_SERVICE_NAME = "TestService";
    private static final String DEFAULT_TEST_PORT_NAME = "TestPort";
    private final SoapClient soapClient;

    public TestSoapClient(SoapWebServiceConfiguration config) {
        this.soapClient = this.getClient(config);
    }

    private SoapClient getClient(SoapWebServiceConfiguration config) {
        try {
            return new SoapCxfClientFactory().create(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static SoapWebServiceConfigurationBuilder getDefaultConfiguration(String address) {
        return SoapWebServiceConfiguration.builder().withAddress(address).withWsdlLocation(address + "?wsdl").withService(DEFAULT_TEST_SERVICE_NAME).withPort(DEFAULT_TEST_PORT_NAME);
    }

    public SoapResponse consume(SoapRequest request, TransportDispatcher dispatcher) {
        return this.soapClient.consume(request, (TransportDispatcher)(dispatcher == null ? new TestHttpDispatcher() : dispatcher));
    }

    public SoapResponse parseResponse(String operation, TransportResponse response) throws BadResponseException {
        return this.soapClient.parseResponse(operation, response);
    }

    public void destroy() {
        this.soapClient.destroy();
    }
}

