/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.runtime;

import java.net.URL;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mule.soap.AbstractSoapServiceTestCase;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.message.SoapRequest;
import org.mule.soap.api.message.SoapResponse;
import org.mule.soap.internal.client.TestSoapClient;
import org.mule.soap.internal.message.DefaultSoapRequest;
import org.mule.soap.service.RM11Service;
import org.mule.soap.service.RM12Service;

public class RMExecutionTestCase
extends AbstractSoapServiceTestCase {
    private URL wsdl;

    @Override
    protected String getServiceClass() {
        return this.soapVersion.equals((Object)SoapVersion.SOAP_11) ? RM11Service.class.getName() : RM12Service.class.getName();
    }

    @Override
    protected void doBefore() {
        this.wsdl = Thread.currentThread().getContextClassLoader().getResource("wsdl/simple-service.wsdl");
        this.client = new TestSoapClient(TestSoapClient.getDefaultConfiguration(this.server.getDefaultAddress()).withWsdlLocation(this.wsdl.getPath()).withVersion(this.soapVersion).includeRMOperations(true).build());
    }

    @Test
    public void createRMSequence() throws Exception {
        DefaultSoapRequest request = SoapRequest.builder().content(this.testValues.getCreateSequenceRequest()).operation("CreateSequence").build();
        SoapResponse response = this.client.consume((SoapRequest)request, null);
        MatcherAssert.assertThat((Object)response.getSoapHeaders().isEmpty(), (Matcher)Is.is((Object)true));
        SoapTestUtils.assertSimilarXml(this.testValues.getCreateSequenceResponse(), response.getContent());
    }
}

