/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.api;

import java.util.List;
import org.mule.soap.api.SoapVersion;
import org.mule.soap.api.SoapWebServiceConfigurationBuilder;
import org.mule.soap.api.security.SecurityStrategy;
import org.mule.soap.api.transport.locator.TransportResourceLocator;

public final class SoapWebServiceConfiguration {
    private final String wsdlLocation;
    private final String address;
    private final String service;
    private final String port;
    private final SoapVersion version;
    private final boolean mtomEnabled;
    private final List<SecurityStrategy> securities;
    private final TransportResourceLocator locator;
    private final String encoding;
    private final boolean includeRMOperations;

    SoapWebServiceConfiguration(String wsdlLocation, String address, String service, String port, SoapVersion version, boolean mtomEnabled, List<SecurityStrategy> securities, TransportResourceLocator locator, String encoding) {
        this(wsdlLocation, address, service, port, version, mtomEnabled, securities, locator, encoding, false);
    }

    SoapWebServiceConfiguration(String wsdlLocation, String address, String service, String port, SoapVersion version, boolean mtomEnabled, List<SecurityStrategy> securities, TransportResourceLocator locator, String encoding, boolean includeRMOperations) {
        this.wsdlLocation = wsdlLocation;
        this.address = address;
        this.service = service;
        this.port = port;
        this.version = version;
        this.mtomEnabled = mtomEnabled;
        this.securities = securities;
        this.locator = locator;
        this.encoding = encoding;
        this.includeRMOperations = includeRMOperations;
    }

    public static SoapWebServiceConfigurationBuilder builder() {
        return new SoapWebServiceConfigurationBuilder();
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public String getAddress() {
        return this.address;
    }

    public String getService() {
        return this.service;
    }

    public String getPort() {
        return this.port;
    }

    public SoapVersion getVersion() {
        return this.version;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public List<SecurityStrategy> getSecurities() {
        return this.securities;
    }

    public String getEncoding() {
        return this.encoding == null ? "UTF-8" : this.encoding;
    }

    public TransportResourceLocator getLocator() {
        return this.locator;
    }

    public boolean includeRMOperations() {
        return this.includeRMOperations;
    }
}

