/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.client;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.endpoint.Client;
import org.jetbrains.annotations.NotNull;
import org.mule.soap.api.SoapWebServiceConfiguration;
import org.mule.soap.api.client.SoapClient;
import org.mule.soap.api.client.SoapClientFactory;
import org.mule.soap.api.client.SoapConfigurationException;
import org.mule.soap.api.transport.locator.TransportResourceLocator;
import org.mule.soap.internal.client.AbstractSoapCxfClient;
import org.mule.soap.internal.client.CxfClientProvider;
import org.mule.soap.internal.client.DefaultSoapCxfClient;
import org.mule.soap.internal.client.SoapMtomCxfClient;
import org.mule.soap.internal.util.OperationModelUtils;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.locator.ResourceLocator;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;
import org.mule.wsdl.parser.model.WsdlStyle;
import org.mule.wsdl.parser.model.operation.OperationModel;

public class SoapCxfClientFactory
implements SoapClientFactory {
    private CxfClientProvider cxfClientProvider = new CxfClientProvider();
    private static final String CREATE_SEQUENCE_OPERATION = "CreateSequence";
    private transient Cache<String, WsdlModel> wsdlModelCache = Caffeine.newBuilder().maximumSize(32L).build();

    @Override
    public SoapClient create(SoapWebServiceConfiguration config) throws SoapConfigurationException {
        WsdlModel wsdl = this.getWsdlDefinition(config);
        Client client = this.cxfClientProvider.getClient(config);
        ServiceModel service = wsdl.getService(config.getService());
        if (service == null) {
            throw new SoapConfigurationException("Service [" + config.getService() + "] is not defined in the wsdl");
        }
        PortModel port = service.getPort(config.getPort());
        if (port == null) {
            throw new SoapConfigurationException("Port [" + config.getPort() + "] not found in service [" + service.getName() + "]");
        }
        String address = this.getAddress(config, port.getAddress());
        AbstractSoapCxfClient cxfClient = config.isMtomEnabled() ? new SoapMtomCxfClient(client, wsdl, port, address, config.getEncoding()) : new DefaultSoapCxfClient(client, wsdl, port, address, config.getEncoding());
        if (config.includeRMOperations()) {
            HashMap<String, OperationModel> operations = new HashMap<String, OperationModel>();
            operations.put(CREATE_SEQUENCE_OPERATION, OperationModelUtils.from(CREATE_SEQUENCE_OPERATION, config.getVersion()));
            cxfClient.addOperations(operations);
        }
        return cxfClient;
    }

    private String getAddress(SoapWebServiceConfiguration config, String serviceAddress) throws SoapConfigurationException {
        String configAddress = config.getAddress();
        if (configAddress == null && serviceAddress == null) {
            throw new SoapConfigurationException("No address was specified and no one was found for the given configuration");
        }
        return StringUtils.isNotBlank((CharSequence)configAddress) ? configAddress : serviceAddress;
    }

    private WsdlModel getWsdlDefinition(SoapWebServiceConfiguration config) throws SoapConfigurationException {
        String location = config.getWsdlLocation();
        WsdlModel wsdlModel = (WsdlModel)this.wsdlModelCache.get((Object)location, k -> WsdlParser.Companion.parse(location, (ResourceLocator)new ResourceLocatorAdapter(config.getLocator()), config.getEncoding()));
        if (WsdlStyle.RPC.equals((Object)wsdlModel.getStyle())) {
            throw new SoapConfigurationException(String.format("The provided WSDL [%s] is RPC style, RPC WSDLs are not supported", location));
        }
        return wsdlModel;
    }

    private static class ResourceLocatorAdapter
    implements ResourceLocator {
        private final TransportResourceLocator locator;

        ResourceLocatorAdapter(TransportResourceLocator locator) {
            this.locator = locator;
        }

        public boolean handles(String s) {
            return this.locator.handles(s);
        }

        @NotNull
        public InputStream getResource(String s) {
            return this.locator.getResource(s);
        }
    }
}

