/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator.attachment;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.cxf.message.Exchange;
import org.jetbrains.annotations.Nullable;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.soap.internal.util.CopyStream;
import org.mule.wsdl.parser.model.operation.OperationModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AttachmentResponseEnricher {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentResponseEnricher.class);
    private static final AtomicBoolean alreadyLoggedWarning = new AtomicBoolean();
    private static final XMLInputFactory xmlInputFactory = new WstxInputFactory();
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static final String ENVELOPE_BODY_TAG = "Body";
    private final Map<String, OperationModel> operations;

    AttachmentResponseEnricher(List<OperationModel> operations) {
        this.operations = operations.stream().collect(Collectors.toMap(OperationModel::getName, Function.identity(), (op1, op2) -> {
            if (alreadyLoggedWarning.compareAndSet(false, true)) {
                LOGGER.warn("Overloaded operations with different outputs are not fully supported");
            }
            return op1;
        }));
    }

    public InputStream enrich(XMLStreamReader xmlStreamReader, String operation, Exchange exchange) throws XMLStreamException {
        Collection attachmentsFields;
        MetadataType attachments;
        if (this.operations.containsKey(operation) && (attachments = this.operations.get(operation).getOutputType().getAttachments()) instanceof ObjectType && !(attachmentsFields = ((ObjectType)attachments).getFields()).isEmpty()) {
            return this.processXmlStream(xmlStreamReader, attachmentsFields, exchange);
        }
        return this.processXmlStream(xmlStreamReader, Collections.emptySet(), exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream processXmlStream(XMLStreamReader xmlStreamReader, Collection<ObjectFieldType> attachmentsFields, Exchange exchange) throws XMLStreamException {
        List<String> attachmentNames = attachmentsFields.stream().map(MetadataTypeUtils::getLocalPart).collect(Collectors.toList());
        XmlEventEnricher eventEnricher = attachmentNames.isEmpty() ? new VoidXmlEventEnricher() : new XmlEventEnricher();
        XMLEventReader xmlEventReader = null;
        XMLEventWriter xmlEventWriter = null;
        CopyStream outputByteStream = new CopyStream();
        try {
            XMLEvent xmlEvent;
            xmlEventReader = xmlInputFactory.createXMLEventReader(xmlStreamReader);
            xmlEventWriter = xmlOutputFactory.createXMLEventWriter(outputByteStream);
            while (!(!xmlEventReader.hasNext() || (xmlEvent = xmlEventReader.nextEvent()).isEndElement() && xmlEvent.asEndElement().getName().getLocalPart().equals(ENVELOPE_BODY_TAG) && (xmlEvent.asEndElement().getName().getNamespaceURI().equals("http://schemas.xmlsoap.org/soap/envelope/") || xmlEvent.asEndElement().getName().getNamespaceURI().equals("http://www.w3.org/2003/05/soap-envelope")))) {
                XMLEvent enrichedEvent = eventEnricher.enrich(xmlEvent, attachmentNames, exchange);
                if (enrichedEvent == null) continue;
                xmlEventWriter.add(enrichedEvent);
            }
            xmlEventWriter.flush();
        }
        finally {
            try {
                xmlStreamReader.close();
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Could not close XMLStreamReader", (Throwable)e);
            }
            try {
                if (xmlEventReader != null) {
                    xmlEventReader.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Could not close XMLEventReader", (Throwable)e);
            }
            try {
                if (xmlEventWriter != null) {
                    xmlEventWriter.close();
                }
            }
            catch (XMLStreamException e) {
                LOGGER.warn("Could not close XMLEventWriter", (Throwable)e);
            }
        }
        return outputByteStream.toInputStream();
    }

    protected abstract void processAttachmentData(String var1, String var2, Exchange var3);

    static {
        xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", true);
    }

    private class VoidXmlEventEnricher
    extends XmlEventEnricher {
        private VoidXmlEventEnricher() {
        }

        @Override
        protected XMLEvent enrich(XMLEvent xmlEvent, List<String> attachmentNames, Exchange exchange) {
            return xmlEvent;
        }
    }

    private class XmlEventEnricher {
        private boolean processingAttachmentElement;
        private String attachmentName;

        private XmlEventEnricher() {
        }

        @Nullable
        protected XMLEvent enrich(XMLEvent xmlEvent, List<String> attachmentNames, Exchange exchange) {
            StartElement startElement;
            String localPart;
            if (this.processingAttachmentElement && xmlEvent.isEndElement()) {
                EndElement startElement2 = xmlEvent.asEndElement();
                String localPart2 = startElement2.getName().getLocalPart();
                if (localPart2.equals(this.attachmentName)) {
                    this.processingAttachmentElement = false;
                    this.attachmentName = null;
                }
                return null;
            }
            if (this.processingAttachmentElement) {
                if (xmlEvent.isCharacters()) {
                    String data = xmlEvent.asCharacters().getData();
                    AttachmentResponseEnricher.this.processAttachmentData(this.attachmentName, data, exchange);
                }
                return null;
            }
            if (xmlEvent.isStartElement() && attachmentNames.contains(localPart = (startElement = xmlEvent.asStartElement()).getName().getLocalPart())) {
                this.processingAttachmentElement = true;
                this.attachmentName = localPart;
                return null;
            }
            return xmlEvent;
        }
    }
}

