package org.mule.soap.api.transport;

/**
 * This interface allows that different transports (such as JMS or HTTP) behave the same way when dispatching a
 * Web Service operation message.
 * <p>
 * The connection with the external server should be managed by the implementation of the dispatcher
 * the client that accepts this {@link TransportDispatcher}s will only call the dispatch method once the request has been built
 * and will use the received response to continue the processing.
 *
 * @since 1.0
 */
public interface TransportDispatcher {

  /**
   * Dispatches a soap message that is contained in a {@link TransportRequest} instance.
   *
   * @param request a {@link TransportRequest} instance.
   * @return a new {@link TransportResponse} instance.
   */
  TransportResponse dispatch(TransportRequest request) throws DispatcherException;
}
