package org.mule.soap.internal.rm;

import org.mule.soap.api.rm.CreateSequenceRequest;

import java.util.Optional;

import static java.util.Optional.ofNullable;

/**
 * Default implementation of a {@link CreateSequenceRequest}
 *
 * @since 1.6
 */
public class DefaultCreateSequenceRequest implements CreateSequenceRequest {

  private final long sequenceTtl;
  private final String namespaceUri;
  private final String addressingNamespaceUri;

  public DefaultCreateSequenceRequest(long sequenceTtl, String namespaceUri, String addressingNamespaceUri) {
    this.sequenceTtl = sequenceTtl;
    this.namespaceUri = namespaceUri;
    this.addressingNamespaceUri = addressingNamespaceUri;
  }

  @Override
  public long getSequenceTtl() {
    return sequenceTtl;
  }

  @Override
  public String getNamespaceUri() {
    return namespaceUri;
  }

  @Override
  public Optional<String> getAddressingNamespaceUri() {
    return ofNullable(addressingNamespaceUri);
  }
}
