/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor;

import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.rm.RMCaptureOutInterceptor;
import org.apache.cxf.ws.rm.RMOutInterceptor;
import org.apache.cxf.ws.rm.soap.RMSoapOutInterceptor;
import org.mule.soap.internal.interceptor.SkipAddressingOutInterceptor;
import org.mule.soap.internal.rm.RMUtils;

public class SkipReliableMessagingOutInterceptor
extends AbstractSoapInterceptor {
    private final RMOutInterceptor rmLogicalOut;
    private final RMSoapOutInterceptor rmOutCodec;
    private final RMCaptureOutInterceptor rmCaptureOut;

    public SkipReliableMessagingOutInterceptor(RMOutInterceptor rmLogicalOut, RMSoapOutInterceptor rmOutCodec, RMCaptureOutInterceptor rmCaptureOut) {
        super(SkipReliableMessagingOutInterceptor.class.getName(), "setup");
        this.addBefore(SkipAddressingOutInterceptor.class.getName());
        this.rmLogicalOut = rmLogicalOut;
        this.rmOutCodec = rmOutCodec;
        this.rmCaptureOut = rmCaptureOut;
    }

    public void handleMessage(SoapMessage soapMessage) {
        if (!RMUtils.isReliableMessagingEnable((Message)soapMessage)) {
            soapMessage.getInterceptorChain().remove((Interceptor)this.rmLogicalOut);
            soapMessage.getInterceptorChain().remove((Interceptor)this.rmOutCodec);
            soapMessage.getInterceptorChain().remove((Interceptor)this.rmCaptureOut);
        }
    }
}

