/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.interceptor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import java.util.TreeMap;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.mule.soap.api.transport.TransportRequest;
import org.mule.soap.internal.util.DelegatingOutputStream;

public class TransportRequestFactory {
    public static TransportRequest createDispatchingRequest(Message message) {
        Exchange exchange = message.getExchange();
        String action = (String)exchange.get((Object)"mule.soap.action");
        String contentType = TransportRequestFactory.getContentType(message);
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        headers.put("SOAPAction", action);
        headers.put("Content-Type", contentType);
        headers.putAll((Map)exchange.get((Object)"mule.soap.transport.headers"));
        ByteArrayOutputStream outputStream = ((DelegatingOutputStream)message.getContent(DelegatingOutputStream.class)).getOutputStream();
        ByteArrayInputStream content = new ByteArrayInputStream(outputStream.toByteArray());
        return new TransportRequest(content, (String)exchange.get((Object)"mule.soap.address"), headers);
    }

    private static String getContentType(Message message) {
        String contentTypeString = (String)message.get((Object)"Content-Type");
        if (!StringUtils.isBlank((CharSequence)contentTypeString)) {
            try {
                ContentType contentType = new ContentType(contentTypeString);
                String charset = (String)message.get((Object)Message.ENCODING);
                if (TransportRequestFactory.isXMLSubType(contentType.getSubType()).booleanValue() && !StringUtils.isBlank((CharSequence)charset)) {
                    contentType.setParameter("charset", charset);
                }
                return contentType.toString();
            }
            catch (ParseException e) {
                return contentTypeString;
            }
        }
        return null;
    }

    private static Boolean isXMLSubType(String subType) {
        return subType.equalsIgnoreCase("xml") || subType.equalsIgnoreCase("soap+xml");
    }
}

