/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.exception;

/**
 * {@link Exception} implementation that aims to be thrown when an inconsistent WSDL state is found or a provided one cannot be
 * parsed.
 *
 * @since 1.0
 */
public final class InvalidWsdlException extends RuntimeException {

  public InvalidWsdlException(String message) {
    super(message);
  }

  public InvalidWsdlException(String message, Throwable cause) {
    super(message, cause);
  }
}
