/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.api.security.stores;

import org.apache.wss4j.common.crypto.Merlin;

import java.util.Properties;

import static org.apache.wss4j.common.crypto.Merlin.KEYSTORE_ALIAS;
import static org.apache.wss4j.common.crypto.Merlin.KEYSTORE_FILE;
import static org.apache.wss4j.common.crypto.Merlin.KEYSTORE_PASSWORD;
import static org.apache.wss4j.common.crypto.Merlin.KEYSTORE_PRIVATE_PASSWORD;
import static org.apache.wss4j.common.crypto.Merlin.KEYSTORE_TYPE;

/**
 * Default {@link WssStoreConfiguration} implementation for Key Stores, used for encryption, decryption and signing.
 *
 * @since 1.0
 */
public class WssKeyStoreConfiguration implements WssStoreConfiguration {

  private final String alias;
  private final String keyPassword;
  private final String password;
  private final String keyStorePath;
  private final String type;

  public WssKeyStoreConfiguration(String alias, String password, String keyStorePath, String keyPassword, String type) {
    this.alias = alias;
    this.keyPassword = keyPassword;
    this.password = password;
    this.keyStorePath = keyStorePath;
    this.type = type;
  }

  public WssKeyStoreConfiguration(String alias, String password, String keyStorePath) {
    this.alias = alias;
    this.password = password;
    this.keyStorePath = keyStorePath;
    this.keyPassword = null;
    this.type = "jks";
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Properties getConfigurationProperties() {
    Properties properties = new Properties();
    properties.setProperty(WS_CRYPTO_PROVIDER_KEY, Merlin.class.getCanonicalName());
    properties.setProperty(MERLIN_PROP_PREFIX + KEYSTORE_TYPE, type);

    if (password != null) {
      properties.setProperty(MERLIN_PROP_PREFIX + KEYSTORE_PASSWORD, password);
    }
    if (alias != null) {
      properties.setProperty(MERLIN_PROP_PREFIX + KEYSTORE_ALIAS, alias);
    }
    if (keyStorePath != null) {
      properties.setProperty(MERLIN_PROP_PREFIX + KEYSTORE_FILE, keyStorePath);
    }
    if (keyPassword != null) {
      properties.setProperty(KEYSTORE_PRIVATE_PASSWORD, keyPassword);
    }

    return properties;
  }

  public String getKeyPassword() {
    return keyPassword;
  }

  public String getAlias() {
    return alias;
  }

  public String getPassword() {
    return password;
  }
}
