/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.soap.api.transport.locator;

import java.io.InputStream;

import org.mule.wsdl.parser.locator.GlobalResourceLocator;
import org.mule.wsdl.parser.locator.ResourceLocator;

/**
 * Default implementation of a {@link TransportResourceLocator}. Tries to handle every resource by delegating to
 * a {@link GlobalResourceLocator}.
 *
 * @since 1.0
 */
public final class DefaultTransportResourceLocator implements TransportResourceLocator {

  private ResourceLocator locator = new GlobalResourceLocator();

  @Override
  public boolean handles(String url) {
    return locator.handles(url);
  }

  @Override
  public InputStream getResource(String url) {
    return locator.getResource(url);
  }
}
