package org.mule.soap.internal.interceptor;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.rm.RMCaptureOutInterceptor;
import org.apache.cxf.ws.rm.persistence.RMStoreException;

/**
 * CXF interceptor that throws a fault in case the message contains an error because a sequence hasn't been stored or
 * updated in the RM Store. This will result in aborting the process of sending a RM message and throwing an exception
 * to be handled by the connector and then by the application.
 *
 * @since 1.6
 */
public class MuleRMCaptureOutInterceptor extends RMCaptureOutInterceptor {

  @Override
  public void handleFault(Message message) {
    Exception exception = message.getContent(Exception.class);
    if (exception instanceof RMStoreException) {
      throw new Fault(exception);
    }
  }
}
