/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.soap.internal.interceptor;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.mule.soap.internal.client.AbstractSoapCxfClient;

import static org.apache.cxf.phase.Phase.PRE_LOGICAL;

/**
 * CXF interceptor that adds the SOAP action to the outgoing request message.
 *
 * @since 1.0
 */
public class SoapActionInterceptor extends AbstractPhaseInterceptor<Message> {

  public static final String SOAP_ACTION = "SOAPAction";

  public SoapActionInterceptor() {
    super(PRE_LOGICAL);
  }

  @Override
  public void handleMessage(Message message) throws Fault {
    String soapAction = (String) message.getExchange().get(AbstractSoapCxfClient.MULE_SOAP_ACTION);
    message.put(SOAP_ACTION, soapAction);
  }
}
