/*
 * Decompiled with CFR 0.152.
 */
package org.mule.soap.internal.generator;

import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.soap.SoapTestUtils;
import org.mule.soap.api.message.SoapAttachment;
import org.mule.soap.internal.generator.AbstractEnricherTestCase;
import org.mule.soap.internal.generator.attachment.AttachmentResponseEnricher;
import org.mule.soap.internal.generator.attachment.SoapAttachmentResponseEnricher;

public class SoapAttachmentsResponseEnricherTestCase
extends AbstractEnricherTestCase {
    private AttachmentResponseEnricher enricher;

    @Override
    @Before
    public void setup() {
        super.setup();
        List ops = this.model.getService("TestService").getPort("TestPort").getOperations();
        this.enricher = new SoapAttachmentResponseEnricher(ops);
    }

    @Test
    public void enrichWindows1252EncodingAttachment() throws Exception {
        String result;
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>QWxndW0gQ29udGX6ZG8gZW0gUG9ydHVndepzIHBhcmEgV2luZG93cw==</attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        try (InputStream enrichedResponse = this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);){
            result = IOUtils.toString((InputStream)enrichedResponse, (Charset)StandardCharsets.UTF_8);
        }
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange, "Algum Conte\u00fado em Portugu\u00eas para Windows", "windows-1252");
    }

    @Test
    public void enrichUtf8EncodingAttachment() throws Exception {
        String result;
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>U29tZSBDb250ZW50</attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        try (InputStream enrichedResponse = this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);){
            result = IOUtils.toString((InputStream)enrichedResponse, (Charset)StandardCharsets.UTF_8);
        }
        SoapTestUtils.assertSimilarXml(this.testValues.getDownloadAttachmentResponse(), result);
        this.assertAttachment((Exchange)exchange, "Some Content", "UTF-8");
    }

    @Test
    public void enrichLargeAttachment() throws Exception {
        String largeContent = IOUtils.resourceToString((String)"large.json", (Charset)StandardCharsets.UTF_8, (ClassLoader)Thread.currentThread().getContextClassLoader());
        String response = "<con:downloadAttachmentResponse xmlns:con=\"http://service.soap.mule.org/\"><attachment>" + Base64.getEncoder().encodeToString(largeContent.getBytes()) + "</attachment></con:downloadAttachmentResponse>";
        StringReader reader = new StringReader(response);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader responseXmlReader = factory.createXMLStreamReader(reader);
        ExchangeImpl exchange = new ExchangeImpl();
        this.enricher.enrich(responseXmlReader, "downloadAttachment", (Exchange)exchange);
        this.assertAttachment((Exchange)exchange, largeContent, "UTF-8");
    }

    private void assertAttachment(Exchange exchange, String attachmentText, String attachmentEncoding) throws Exception {
        Map attachments = (Map)exchange.get((Object)"mule.soap.attachments");
        MatcherAssert.assertThat(attachments.entrySet(), (Matcher)Matchers.hasSize((int)1));
        String value = IOUtils.toString((InputStream)((SoapAttachment)attachments.get("attachment")).getContent(), (String)attachmentEncoding);
        MatcherAssert.assertThat((Object)value, (Matcher)Matchers.is((Object)attachmentText));
    }
}

